/*
 * Note: this file originally auto-generated by mib2c using
 *        $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "systemToolReboot.h"

#include <linux/version.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <pthread.h>
#include <time.h>

int reboot = NOT_REBOOT;
int rebootEap();
/** Initializes the systemToolReboot module */
void
init_systemToolReboot(void)
{
    const oid systemToolReboot_oid[] = { 1,3,6,1,4,1,11863,10,1,2,1 };

  DEBUGMSGTL(("systemToolReboot", "Initializing\n"));

    netsnmp_register_scalar(
        netsnmp_create_handler_registration("systemToolReboot", handle_systemToolReboot,
                               systemToolReboot_oid, OID_LENGTH(systemToolReboot_oid),
                               HANDLER_CAN_RWRITE
        ));

}

int
handle_systemToolReboot(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &reboot,
                                    sizeof(reboot));
            break;
			
        case MODE_SET_RESERVE1:
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }

	    if ( REBOOT == (*requests->requestvb->val.integer))
	    {
			reboot = REBOOT;		
			rebootEap();
	    }
	    else
	    {
			reboot = NOT_REBOOT;
	    }
		
            break;

        case MODE_SET_RESERVE2:
        case MODE_SET_FREE:
        case MODE_SET_ACTION:
        case MODE_SET_COMMIT:
        case MODE_SET_UNDO:
            break;
        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_systemToolReboot\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

#if 0
int fd = -1;
static int gpio_open()
{
	fd = open("/dev/ar7100_gpio_chrdev", O_RDONLY | O_CREAT);
	if (-1 == fd)
	{
		printf("open device ar7100_gpio_chrdev failed\n");
		return -1;
	}

	return 0;
}


void sysStopFeeddog()
{
	if (fd <= 0)
	{
		if (gpio_open() < 0)
			return;
	}
	
	fprintf(stderr, "%s: Stop feeding dog\n",__FUNCTION__);
	ioctl(fd, AR7100_GPIO_STOP_FEEDDOG, NULL);	
}
#endif
int rebootEap()
{
	int pid = 0, status = 0;
	char *newCommand = NULL;
	
 	pid = fork();
	if ( pid == -1 )
	{
		printf("Error to reboot!\n");
		return -1;
	}
	
	if ( pid == 0 ) 
	{
		char *argv[4];
		argv[0] = "sh";
		argv[1] = "-c";
		argv[2] = "reboot";
		argv[3] = 0;

		execve("/bin/sh", argv, NULL);
		exit(127);
	}

	/* wait for child process return */
	////////
	do 
	{
		if ( waitpid(pid, &status, 0) == -1 )
		{
	   	}
		else
		{
	     	return status;
		}
	} while ( 1 );

	return 0;
}

