/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef __DTS_MT7622_PINFUNC_H
#define __DTS_MT7622_PINFUNC_H

#include <dt-bindings/pinctrl/mt65xx.h>

#define MT7622_PIN_0_GPIO_A__FUNC_GPIO0 (MTK_PIN_NO(0) | 1)

#define MT7622_PIN_1_I2S1_IN__FUNC_I2S1_IN (MTK_PIN_NO(1) | 0)
#define MT7622_PIN_1_I2S1_IN__FUNC_GPIO1 (MTK_PIN_NO(1) | 1)
#define MT7622_PIN_1_I2S1_IN__FUNC_RTS2_N (MTK_PIN_NO(1) | 2)

#define MT7622_PIN_2_I2S1_OUT__FUNC_I2S1_OUT (MTK_PIN_NO(2) | 0)
#define MT7622_PIN_2_I2S1_OUT__FUNC_GPIO2 (MTK_PIN_NO(2) | 1)
#define MT7622_PIN_2_I2S1_OUT__FUNC_CTS2_N (MTK_PIN_NO(2) | 2)

#define MT7622_PIN_3_I2S_BCLK__FUNC_I2S_BCLK_OUT (MTK_PIN_NO(3) | 0)
#define MT7622_PIN_3_I2S_BCLK__FUNC_GPIO3 (MTK_PIN_NO(3) | 1)
#define MT7622_PIN_3_I2S_BCLK__FUNC_TXD2 (MTK_PIN_NO(3) | 2)
#define MT7622_PIN_3_I2S_BCLK__FUNC_I2S_BCLK_IN (MTK_PIN_NO(3) | 3)

#define MT7622_PIN_4_I2S_WS__FUNC_I2S_WS_OUT (MTK_PIN_NO(4) | 0)
#define MT7622_PIN_4_I2S_WS__FUNC_GPIO4 (MTK_PIN_NO(4) | 1)
#define MT7622_PIN_4_I2S_WS__FUNC_RXD2 (MTK_PIN_NO(4) | 2)
#define MT7622_PIN_4_I2S_WS__FUNC_I2S_WS_IN (MTK_PIN_NO(4) | 3)

#define MT7622_PIN_5_I2S_MCLK__FUNC_I2S_MCLK (MTK_PIN_NO(5) | 0)
#define MT7622_PIN_5_I2S_MCLK__FUNC_GPIO5 (MTK_PIN_NO(5) | 1)
#define MT7622_PIN_5_I2S_MCLK__FUNC_DBG_UTIF17 (MTK_PIN_NO(5) | 7)

#define MT7622_PIN_6_TXD0__FUNC_TXD0 (MTK_PIN_NO(6) | 0)
#define MT7622_PIN_6_TXD0__FUNC_GPIO6 (MTK_PIN_NO(6) | 1)
#define MT7622_PIN_6_TXD0__FUNC_TM_SUTIF_TXD (MTK_PIN_NO(6) | 7)

#define MT7622_PIN_7_RXD0__FUNC_RXD0 (MTK_PIN_NO(7) | 0)
#define MT7622_PIN_7_RXD0__FUNC_GPIO7 (MTK_PIN_NO(7) | 1)
#define MT7622_PIN_7_RXD0__FUNC_TM_SUTIF_RXD (MTK_PIN_NO(7) | 7)

#define MT7622_PIN_8_SPI_WP__FUNC_SPI_WP (MTK_PIN_NO(8) | 0)
#define MT7622_PIN_8_SPI_WP__FUNC_GPIO8 (MTK_PIN_NO(8) | 1)
#define MT7622_PIN_8_SPI_WP__FUNC_SNFI_WP (MTK_PIN_NO(8) | 2)
#define MT7622_PIN_8_SPI_WP__FUNC_TDM_OUT_MCLK (MTK_PIN_NO(8) | 3)
#define MT7622_PIN_8_SPI_WP__FUNC_FPC_DAT_STS (MTK_PIN_NO(8) | 6)

#define MT7622_PIN_9_SPI_HOLD__FUNC_SPI_HOLD (MTK_PIN_NO(9) | 0)
#define MT7622_PIN_9_SPI_HOLD__FUNC_GPIO9 (MTK_PIN_NO(9) | 1)
#define MT7622_PIN_9_SPI_HOLD__FUNC_SNFI_HOLD (MTK_PIN_NO(9) | 2)
#define MT7622_PIN_9_SPI_HOLD__FUNC_TDM_OUT_BCLK (MTK_PIN_NO(9) | 3)
#define MT7622_PIN_9_SPI_HOLD__FUNC_FPC_DL_STS (MTK_PIN_NO(9) | 6)

#define MT7622_PIN_10_SPI_CLK__FUNC_SPI_CLK (MTK_PIN_NO(10) | 0)
#define MT7622_PIN_10_SPI_CLK__FUNC_GPIO10 (MTK_PIN_NO(10) | 1)
#define MT7622_PIN_10_SPI_CLK__FUNC_SNFI_CLK (MTK_PIN_NO(10) | 2)
#define MT7622_PIN_10_SPI_CLK__FUNC_TDM_OUT_WS (MTK_PIN_NO(10) | 3)

#define MT7622_PIN_11_SPI_MOSI__FUNC_SPI_MOSI (MTK_PIN_NO(11) | 0)
#define MT7622_PIN_11_SPI_MOSI__FUNC_GPIO11 (MTK_PIN_NO(11) | 1)
#define MT7622_PIN_11_SPI_MOSI__FUNC_SNFI_MOSI (MTK_PIN_NO(11) | 2)
#define MT7622_PIN_11_SPI_MOSI__FUNC_TDM_IN_MCLK (MTK_PIN_NO(11) | 3)

#define MT7622_PIN_12_SPI_MISO__FUNC_SPI_MISO (MTK_PIN_NO(12) | 0)
#define MT7622_PIN_12_SPI_MISO__FUNC_GPIO12 (MTK_PIN_NO(12) | 1)
#define MT7622_PIN_12_SPI_MISO__FUNC_SNFI_MISO (MTK_PIN_NO(12) | 2)
#define MT7622_PIN_12_SPI_MISO__FUNC_TDM_IN_BCLK (MTK_PIN_NO(12) | 3)

#define MT7622_PIN_13_SPI_CS__FUNC_SPI_CS (MTK_PIN_NO(13) | 0)
#define MT7622_PIN_13_SPI_CS__FUNC_GPIO13 (MTK_PIN_NO(13) | 1)
#define MT7622_PIN_13_SPI_CS__FUNC_SNFI_CS (MTK_PIN_NO(13) | 2)
#define MT7622_PIN_13_SPI_CS__FUNC_TDM_IN_WS (MTK_PIN_NO(13) | 3)

#define MT7622_PIN_14_I2C_SDA__FUNC_I2C0_SDA (MTK_PIN_NO(14) | 0)
#define MT7622_PIN_14_I2C_SDA__FUNC_GPIO14 (MTK_PIN_NO(14) | 1)
#define MT7622_PIN_14_I2C_SDA__FUNC_PCIE0_PAD_WAKE_N (MTK_PIN_NO(14) | 2)
#define MT7622_PIN_14_I2C_SDA__FUNC_PCIE1_PAD_WAKE_N (MTK_PIN_NO(14) | 3)
#define MT7622_PIN_14_I2C_SDA__FUNC_ANTSEL22 (MTK_PIN_NO(14) | 5)
#define MT7622_PIN_14_I2C_SDA__FUNC_TM_EXT_BGCK (MTK_PIN_NO(14) | 7)

#define MT7622_PIN_15_I2C_SCL__FUNC_I2C0_SCL (MTK_PIN_NO(15) | 0)
#define MT7622_PIN_15_I2C_SCL__FUNC_GPIO15 (MTK_PIN_NO(15) | 1)
#define MT7622_PIN_15_I2C_SCL__FUNC_PCIE0_PAD_CLKREQ_N (MTK_PIN_NO(15) | 2)
#define MT7622_PIN_15_I2C_SCL__FUNC_PCIE1_PAD_CLKREQ_N (MTK_PIN_NO(15) | 3)
#define MT7622_PIN_15_I2C_SCL__FUNC_ANTSEL23 (MTK_PIN_NO(15) | 5)

#define MT7622_PIN_16_I2S2_IN__FUNC_I2S2_IN (MTK_PIN_NO(16) | 0)
#define MT7622_PIN_16_I2S2_IN__FUNC_GPIO16 (MTK_PIN_NO(16) | 1)
#define MT7622_PIN_16_I2S2_IN__FUNC_SD_D3 (MTK_PIN_NO(16) | 2)
#define MT7622_PIN_16_I2S2_IN__FUNC_IR_T (MTK_PIN_NO(16) | 4)
#define MT7622_PIN_16_I2S2_IN__FUNC_ANTSEL24 (MTK_PIN_NO(16) | 5)
#define MT7622_PIN_16_I2S2_IN__FUNC_BT_EPA_EN (MTK_PIN_NO(16) | 6)
#define MT7622_PIN_16_I2S2_IN__FUNC_DBG_UTIF10 (MTK_PIN_NO(16) | 7)

#define MT7622_PIN_17_I2S3_IN__FUNC_I2S3_IN (MTK_PIN_NO(17) | 0)
#define MT7622_PIN_17_I2S3_IN__FUNC_GPIO17 (MTK_PIN_NO(17) | 1)
#define MT7622_PIN_17_I2S3_IN__FUNC_SD_D2 (MTK_PIN_NO(17) | 2)
#define MT7622_PIN_17_I2S3_IN__FUNC_IR_R (MTK_PIN_NO(17) | 4)
#define MT7622_PIN_17_I2S3_IN__FUNC_ANTSEL25 (MTK_PIN_NO(17) | 5)
#define MT7622_PIN_17_I2S3_IN__FUNC_BT_ELNA_EN (MTK_PIN_NO(17) | 6)
#define MT7622_PIN_17_I2S3_IN__FUNC_DBG_UTIF11 (MTK_PIN_NO(17) | 7)

#define MT7622_PIN_18_I2S4_IN__FUNC_I2S4_IN (MTK_PIN_NO(18) | 0)
#define MT7622_PIN_18_I2S4_IN__FUNC_GPIO18 (MTK_PIN_NO(18) | 1)
#define MT7622_PIN_18_I2S4_IN__FUNC_SD_D1 (MTK_PIN_NO(18) | 2)
#define MT7622_PIN_18_I2S4_IN__FUNC_ANTSEL26 (MTK_PIN_NO(18) | 5)
#define MT7622_PIN_18_I2S4_IN__FUNC_BT_ERX_EN (MTK_PIN_NO(18) | 6)
#define MT7622_PIN_18_I2S4_IN__FUNC_DBG_UTIF12 (MTK_PIN_NO(18) | 7)

#define MT7622_PIN_19_I2S2_OUT__FUNC_I2S2_OUT (MTK_PIN_NO(19) | 0)
#define MT7622_PIN_19_I2S2_OUT__FUNC_GPIO19 (MTK_PIN_NO(19) | 1)
#define MT7622_PIN_19_I2S2_OUT__FUNC_SD_D0 (MTK_PIN_NO(19) | 2)
#define MT7622_PIN_19_I2S2_OUT__FUNC_ANTSEL27 (MTK_PIN_NO(19) | 5)
#define MT7622_PIN_19_I2S2_OUT__FUNC_BT_IPATH_EN (MTK_PIN_NO(19) | 6)
#define MT7622_PIN_19_I2S2_OUT__FUNC_DBG_UTIF13 (MTK_PIN_NO(19) | 7)

#define MT7622_PIN_20_I2S3_OUT__FUNC_I2S3_OUT (MTK_PIN_NO(20) | 0)
#define MT7622_PIN_20_I2S3_OUT__FUNC_GPIO20 (MTK_PIN_NO(20) | 1)
#define MT7622_PIN_20_I2S3_OUT__FUNC_SD_CLK (MTK_PIN_NO(20) | 2)
#define MT7622_PIN_20_I2S3_OUT__FUNC_TDM_OUT_DATA (MTK_PIN_NO(20) | 3)
#define MT7622_PIN_20_I2S3_OUT__FUNC_ANTSEL28 (MTK_PIN_NO(20) | 5)
#define MT7622_PIN_20_I2S3_OUT__FUNC_BT_SPXT_C1 (MTK_PIN_NO(20) | 6)
#define MT7622_PIN_20_I2S3_OUT__FUNC_DBG_UTIF14 (MTK_PIN_NO(20) | 7)

#define MT7622_PIN_21_I2S4_OUT__FUNC_I2S4_OUT (MTK_PIN_NO(21) | 0)
#define MT7622_PIN_21_I2S4_OUT__FUNC_GPIO21 (MTK_PIN_NO(21) | 1)
#define MT7622_PIN_21_I2S4_OUT__FUNC_SD_CMD (MTK_PIN_NO(21) | 2)
#define MT7622_PIN_21_I2S4_OUT__FUNC_TDM_IN_DATA (MTK_PIN_NO(21) | 3)
#define MT7622_PIN_21_I2S4_OUT__FUNC_ANTSEL29 (MTK_PIN_NO(21) | 5)
#define MT7622_PIN_21_I2S4_OUT__FUNC_BT_SPXT_C0 (MTK_PIN_NO(21) | 6)
#define MT7622_PIN_21_I2S4_OUT__FUNC_DBG_UTIF15 (MTK_PIN_NO(21) | 7)

#define MT7622_PIN_22_GPIO_B__FUNC_GPIO22 (MTK_PIN_NO(22) | 1)
#define MT7622_PIN_22_GPIO_B__FUNC_TSF_INTR (MTK_PIN_NO(22) | 3)
#define MT7622_PIN_22_GPIO_B__FUNC_ANTSEL17 (MTK_PIN_NO(22) | 5)
#define MT7622_PIN_22_GPIO_B__FUNC_DBG_UTIF16 (MTK_PIN_NO(22) | 7)

#define MT7622_PIN_23_MDC__FUNC_MDC (MTK_PIN_NO(23) | 0)
#define MT7622_PIN_23_MDC__FUNC_GPIO23 (MTK_PIN_NO(23) | 1)

#define MT7622_PIN_24_MDIO__FUNC_MDIO (MTK_PIN_NO(24) | 0)
#define MT7622_PIN_24_MDIO__FUNC_GPIO24 (MTK_PIN_NO(24) | 1)

#define MT7622_PIN_25_G2_TXD0__FUNC_G2_TXD0 (MTK_PIN_NO(25) | 0)
#define MT7622_PIN_25_G2_TXD0__FUNC_GPIO25 (MTK_PIN_NO(25) | 1)
#define MT7622_PIN_25_G2_TXD0__FUNC_SD_D3 (MTK_PIN_NO(25) | 2)

#define MT7622_PIN_26_G2_TXD1__FUNC_G2_TXD1 (MTK_PIN_NO(26) | 0)
#define MT7622_PIN_26_G2_TXD1__FUNC_GPIO26 (MTK_PIN_NO(26) | 1)
#define MT7622_PIN_26_G2_TXD1__FUNC_SD_D2 (MTK_PIN_NO(26) | 2)

#define MT7622_PIN_27_G2_TXD2__FUNC_G2_TXD2 (MTK_PIN_NO(27) | 0)
#define MT7622_PIN_27_G2_TXD2__FUNC_GPIO27 (MTK_PIN_NO(27) | 1)
#define MT7622_PIN_27_G2_TXD2__FUNC_SD_D1 (MTK_PIN_NO(27) | 2)

#define MT7622_PIN_28_G2_TXD3__FUNC_G2_TXD3 (MTK_PIN_NO(28) | 0)
#define MT7622_PIN_28_G2_TXD3__FUNC_GPIO28 (MTK_PIN_NO(28) | 1)
#define MT7622_PIN_28_G2_TXD3__FUNC_SD_D0 (MTK_PIN_NO(28) | 2)

#define MT7622_PIN_29_G2_TXEN__FUNC_G2_TXEN (MTK_PIN_NO(29) | 0)
#define MT7622_PIN_29_G2_TXEN__FUNC_GPIO29 (MTK_PIN_NO(29) | 1)
#define MT7622_PIN_29_G2_TXEN__FUNC_SD_CLK (MTK_PIN_NO(29) | 2)

#define MT7622_PIN_30_G2_TXC__FUNC_G2_TXC (MTK_PIN_NO(30) | 0)
#define MT7622_PIN_30_G2_TXC__FUNC_GPIO30 (MTK_PIN_NO(30) | 1)
#define MT7622_PIN_30_G2_TXC__FUNC_SD_CMD (MTK_PIN_NO(30) | 2)

#define MT7622_PIN_31_G2_RXD0__FUNC_G2_RXD0 (MTK_PIN_NO(31) | 0)
#define MT7622_PIN_31_G2_RXD0__FUNC_GPIO31 (MTK_PIN_NO(31) | 1)
#define MT7622_PIN_31_G2_RXD0__FUNC_G2_GPIO31 (MTK_PIN_NO(31) | 2)

#define MT7622_PIN_32_G2_RXD1__FUNC_G2_RXD1 (MTK_PIN_NO(32) | 0)
#define MT7622_PIN_32_G2_RXD1__FUNC_GPIO32 (MTK_PIN_NO(32) | 1)
#define MT7622_PIN_32_G2_RXD1__FUNC_G2_GPIO32 (MTK_PIN_NO(32) | 2)

#define MT7622_PIN_33_G2_RXD2__FUNC_G2_RXD2 (MTK_PIN_NO(33) | 0)
#define MT7622_PIN_33_G2_RXD2__FUNC_GPIO33 (MTK_PIN_NO(33) | 1)
#define MT7622_PIN_33_G2_RXD2__FUNC_G2_GPIO33 (MTK_PIN_NO(33) | 2)

#define MT7622_PIN_34_G2_RXD3__FUNC_G2_RXD3 (MTK_PIN_NO(34) | 0)
#define MT7622_PIN_34_G2_RXD3__FUNC_GPIO34 (MTK_PIN_NO(34) | 1)
#define MT7622_PIN_34_G2_RXD3__FUNC_G2_GPIO34 (MTK_PIN_NO(34) | 2)

#define MT7622_PIN_35_G2_RXDV__FUNC_G2_RXDV (MTK_PIN_NO(35) | 0)
#define MT7622_PIN_35_G2_RXDV__FUNC_GPIO35 (MTK_PIN_NO(35) | 1)
#define MT7622_PIN_35_G2_RXDV__FUNC_G2_GPIO35 (MTK_PIN_NO(35) | 2)

#define MT7622_PIN_36_G2_RXC__FUNC_G2_RXC (MTK_PIN_NO(36) | 0)
#define MT7622_PIN_36_G2_RXC__FUNC_GPIO36 (MTK_PIN_NO(36) | 1)
#define MT7622_PIN_36_G2_RXC__FUNC_G2_GPIO36 (MTK_PIN_NO(36) | 2)

#define MT7622_PIN_37_NCEB__FUNC_ND_CS_N (MTK_PIN_NO(37) | 0)
#define MT7622_PIN_37_NCEB__FUNC_GPIO37 (MTK_PIN_NO(37) | 1)
#define MT7622_PIN_37_NCEB__FUNC_G2_GPIO37 (MTK_PIN_NO(37) | 2)
#define MT7622_PIN_37_NCEB__FUNC_DBG_UTIF18 (MTK_PIN_NO(37) | 7)

#define MT7622_PIN_38_NWEB__FUNC_ND_WE_N (MTK_PIN_NO(38) | 0)
#define MT7622_PIN_38_NWEB__FUNC_GPIO38 (MTK_PIN_NO(38) | 1)
#define MT7622_PIN_38_NWEB__FUNC_G2_GPIO38 (MTK_PIN_NO(38) | 2)
#define MT7622_PIN_38_NWEB__FUNC_DBG_UTIF19 (MTK_PIN_NO(38) | 7)

#define MT7622_PIN_39_NREB__FUNC_ND_RE_N (MTK_PIN_NO(39) | 0)
#define MT7622_PIN_39_NREB__FUNC_GPIO39 (MTK_PIN_NO(39) | 1)
#define MT7622_PIN_39_NREB__FUNC_G2_GPIO39 (MTK_PIN_NO(39) | 2)
#define MT7622_PIN_39_NREB__FUNC_DBG_UTIF20 (MTK_PIN_NO(39) | 7)

#define MT7622_PIN_40_NDL4__FUNC_ND_D4 (MTK_PIN_NO(40) | 0)
#define MT7622_PIN_40_NDL4__FUNC_GPIO40 (MTK_PIN_NO(40) | 1)
#define MT7622_PIN_40_NDL4__FUNC_EMMC_DATA4 (MTK_PIN_NO(40) | 2)
#define MT7622_PIN_40_NDL4__FUNC_DBG_UTIF21 (MTK_PIN_NO(40) | 7)

#define MT7622_PIN_41_NDL5__FUNC_ND_D5 (MTK_PIN_NO(41) | 0)
#define MT7622_PIN_41_NDL5__FUNC_GPIO41 (MTK_PIN_NO(41) | 1)
#define MT7622_PIN_41_NDL5__FUNC_EMMC_DATA5 (MTK_PIN_NO(41) | 2)
#define MT7622_PIN_41_NDL5__FUNC_DBG_UTIF22 (MTK_PIN_NO(41) | 7)

#define MT7622_PIN_42_NDL6__FUNC_ND_D6 (MTK_PIN_NO(42) | 0)
#define MT7622_PIN_42_NDL6__FUNC_GPIO42 (MTK_PIN_NO(42) | 1)
#define MT7622_PIN_42_NDL6__FUNC_EMMC_DATA6 (MTK_PIN_NO(42) | 2)
#define MT7622_PIN_42_NDL6__FUNC_DBG_UTIF23 (MTK_PIN_NO(42) | 7)

#define MT7622_PIN_43_NDL7__FUNC_ND_D7 (MTK_PIN_NO(43) | 0)
#define MT7622_PIN_43_NDL7__FUNC_GPIO43 (MTK_PIN_NO(43) | 1)
#define MT7622_PIN_43_NDL7__FUNC_EMMC_DATA7 (MTK_PIN_NO(43) | 2)
#define MT7622_PIN_43_NDL7__FUNC_DBG_UTIF24 (MTK_PIN_NO(43) | 7)

#define MT7622_PIN_44_NRB__FUNC_ND_RB_N (MTK_PIN_NO(44) | 0)
#define MT7622_PIN_44_NRB__FUNC_GPIO44 (MTK_PIN_NO(44) | 1)
#define MT7622_PIN_44_NRB__FUNC_EMMC_CMD (MTK_PIN_NO(44) | 2)
#define MT7622_PIN_44_NRB__FUNC_DBG_UTIF25 (MTK_PIN_NO(44) | 7)

#define MT7622_PIN_45_NCLE__FUNC_ND_CLE (MTK_PIN_NO(45) | 0)
#define MT7622_PIN_45_NCLE__FUNC_GPIO45 (MTK_PIN_NO(45) | 1)
#define MT7622_PIN_45_NCLE__FUNC_EMMC_CK (MTK_PIN_NO(45) | 2)
#define MT7622_PIN_45_NCLE__FUNC_DBG_UTIF26 (MTK_PIN_NO(45) | 7)

#define MT7622_PIN_46_NALE__FUNC_ND_ALE (MTK_PIN_NO(46) | 0)
#define MT7622_PIN_46_NALE__FUNC_GPIO46 (MTK_PIN_NO(46) | 1)
#define MT7622_PIN_46_NALE__FUNC_G2_GPIO46 (MTK_PIN_NO(46) | 2)
#define MT7622_PIN_46_NALE__FUNC_DBG_UTIF27 (MTK_PIN_NO(46) | 7)

#define MT7622_PIN_47_NDL0__FUNC_ND_D0 (MTK_PIN_NO(47) | 0)
#define MT7622_PIN_47_NDL0__FUNC_GPIO47 (MTK_PIN_NO(47) | 1)
#define MT7622_PIN_47_NDL0__FUNC_EMMC_DATA0 (MTK_PIN_NO(47) | 2)
#define MT7622_PIN_47_NDL0__FUNC_DBG_UTIF28 (MTK_PIN_NO(47) | 7)

#define MT7622_PIN_48_NDL1__FUNC_ND_D1 (MTK_PIN_NO(48) | 0)
#define MT7622_PIN_48_NDL1__FUNC_GPIO48 (MTK_PIN_NO(48) | 1)
#define MT7622_PIN_48_NDL1__FUNC_EMMC_DATA1 (MTK_PIN_NO(48) | 2)
#define MT7622_PIN_48_NDL1__FUNC_DBG_UTIF29 (MTK_PIN_NO(48) | 7)

#define MT7622_PIN_49_NDL2__FUNC_ND_D2 (MTK_PIN_NO(49) | 0)
#define MT7622_PIN_49_NDL2__FUNC_GPIO49 (MTK_PIN_NO(49) | 1)
#define MT7622_PIN_49_NDL2__FUNC_EMMC_DATA2 (MTK_PIN_NO(49) | 2)
#define MT7622_PIN_49_NDL2__FUNC_DBG_UTIF30 (MTK_PIN_NO(49) | 7)

#define MT7622_PIN_50_NDL3__FUNC_ND_D3 (MTK_PIN_NO(50) | 0)
#define MT7622_PIN_50_NDL3__FUNC_GPIO50 (MTK_PIN_NO(50) | 1)
#define MT7622_PIN_50_NDL3__FUNC_EMMC_DATA3 (MTK_PIN_NO(50) | 2)
#define MT7622_PIN_50_NDL3__FUNC_DBG_UTIF31 (MTK_PIN_NO(50) | 7)

#define MT7622_PIN_51_MDI_TP_P0__FUNC_TXD2 (MTK_PIN_NO(51) | 0)
#define MT7622_PIN_51_MDI_TP_P0__FUNC_GPIO51 (MTK_PIN_NO(51) | 1)
#define MT7622_PIN_51_MDI_TP_P0__FUNC_PWM_CH1 (MTK_PIN_NO(51) | 3)

#define MT7622_PIN_52_MDI_TN_P0__FUNC_RXD2 (MTK_PIN_NO(52) | 0)
#define MT7622_PIN_52_MDI_TN_P0__FUNC_GPIO52 (MTK_PIN_NO(52) | 1)
#define MT7622_PIN_52_MDI_TN_P0__FUNC_PWM_CH2 (MTK_PIN_NO(52) | 3)

#define MT7622_PIN_53_MDI_RP_P0__FUNC_RTS2_N (MTK_PIN_NO(53) | 0)
#define MT7622_PIN_53_MDI_RP_P0__FUNC_GPIO53 (MTK_PIN_NO(53) | 1)
#define MT7622_PIN_53_MDI_RP_P0__FUNC_PWM_CH3 (MTK_PIN_NO(53) | 3)

#define MT7622_PIN_54_MDI_RN_P0__FUNC_CTS2_N (MTK_PIN_NO(54) | 0)
#define MT7622_PIN_54_MDI_RN_P0__FUNC_GPIO54 (MTK_PIN_NO(54) | 1)
#define MT7622_PIN_54_MDI_RN_P0__FUNC_PWM_CH4 (MTK_PIN_NO(54) | 3)

#define MT7622_PIN_55_MDI_TP_P1__FUNC_I2C1_SCL (MTK_PIN_NO(55) | 0)
#define MT7622_PIN_55_MDI_TP_P1__FUNC_GPIO55 (MTK_PIN_NO(55) | 1)
#define MT7622_PIN_55_MDI_TP_P1__FUNC_TXD1 (MTK_PIN_NO(55) | 2)
#define MT7622_PIN_55_MDI_TP_P1__FUNC_TDM_OUT_DATA (MTK_PIN_NO(55) | 3)

#define MT7622_PIN_56_MDI_TN_P1__FUNC_I2C1_SDA (MTK_PIN_NO(56) | 0)
#define MT7622_PIN_56_MDI_TN_P1__FUNC_GPIO56 (MTK_PIN_NO(56) | 1)
#define MT7622_PIN_56_MDI_TN_P1__FUNC_RXD1 (MTK_PIN_NO(56) | 2)
#define MT7622_PIN_56_MDI_TN_P1__FUNC_TDM_IN_DATA (MTK_PIN_NO(56) | 3)

#define MT7622_PIN_57_MDI_RP_P1__FUNC_I2C2_SCL (MTK_PIN_NO(57) | 0)
#define MT7622_PIN_57_MDI_RP_P1__FUNC_GPIO57 (MTK_PIN_NO(57) | 1)
#define MT7622_PIN_57_MDI_RP_P1__FUNC_RTS1_N (MTK_PIN_NO(57) | 2)
#define MT7622_PIN_57_MDI_RP_P1__FUNC_TDM_OUT_MCLK (MTK_PIN_NO(57) | 3)
#define MT7622_PIN_57_MDI_RP_P1__FUNC_TXD3 (MTK_PIN_NO(57) | 5)

#define MT7622_PIN_58_MDI_RN_P1__FUNC_I2C2_SDA (MTK_PIN_NO(58) | 0)
#define MT7622_PIN_58_MDI_RN_P1__FUNC_GPIO58 (MTK_PIN_NO(58) | 1)
#define MT7622_PIN_58_MDI_RN_P1__FUNC_CTS1_N (MTK_PIN_NO(58) | 2)
#define MT7622_PIN_58_MDI_RN_P1__FUNC_TDM_OUT_BCLK (MTK_PIN_NO(58) | 3)
#define MT7622_PIN_58_MDI_RN_P1__FUNC_RXD3 (MTK_PIN_NO(58) | 5)

#define MT7622_PIN_59_MDI_RP_P2__FUNC_ESW_TXD0 (MTK_PIN_NO(59) | 0)
#define MT7622_PIN_59_MDI_RP_P2__FUNC_GPIO59 (MTK_PIN_NO(59) | 1)
#define MT7622_PIN_59_MDI_RP_P2__FUNC_G1_TXD0 (MTK_PIN_NO(59) | 2)
#define MT7622_PIN_59_MDI_RP_P2__FUNC_TDM_OUT_WS (MTK_PIN_NO(59) | 3)
#define MT7622_PIN_59_MDI_RP_P2__FUNC_TXD2 (MTK_PIN_NO(59) | 4)
#define MT7622_PIN_59_MDI_RP_P2__FUNC_IR_T (MTK_PIN_NO(59) | 5)

#define MT7622_PIN_60_MDI_RN_P2__FUNC_ESW_TXD1 (MTK_PIN_NO(60) | 0)
#define MT7622_PIN_60_MDI_RN_P2__FUNC_GPIO60 (MTK_PIN_NO(60) | 1)
#define MT7622_PIN_60_MDI_RN_P2__FUNC_G1_TXD1 (MTK_PIN_NO(60) | 2)
#define MT7622_PIN_60_MDI_RN_P2__FUNC_TDM_IN_MCLK (MTK_PIN_NO(60) | 3)
#define MT7622_PIN_60_MDI_RN_P2__FUNC_RXD2 (MTK_PIN_NO(60) | 4)
#define MT7622_PIN_60_MDI_RN_P2__FUNC_IR_R (MTK_PIN_NO(60) | 5)

#define MT7622_PIN_61_MDI_TP_P2__FUNC_ESW_TXD2 (MTK_PIN_NO(61) | 0)
#define MT7622_PIN_61_MDI_TP_P2__FUNC_GPIO61 (MTK_PIN_NO(61) | 1)
#define MT7622_PIN_61_MDI_TP_P2__FUNC_G1_TXD2 (MTK_PIN_NO(61) | 2)
#define MT7622_PIN_61_MDI_TP_P2__FUNC_TDM_IN_BCLK (MTK_PIN_NO(61) | 3)
#define MT7622_PIN_61_MDI_TP_P2__FUNC_RTS2_N (MTK_PIN_NO(61) | 4)
#define MT7622_PIN_61_MDI_TP_P2__FUNC_TXD4 (MTK_PIN_NO(61) | 5)

#define MT7622_PIN_62_MDI_TN_P2__FUNC_ESW_TXD3 (MTK_PIN_NO(62) | 0)
#define MT7622_PIN_62_MDI_TN_P2__FUNC_GPIO62 (MTK_PIN_NO(62) | 1)
#define MT7622_PIN_62_MDI_TN_P2__FUNC_G1_TXD3 (MTK_PIN_NO(62) | 2)
#define MT7622_PIN_62_MDI_TN_P2__FUNC_TDM_IN_WS (MTK_PIN_NO(62) | 3)
#define MT7622_PIN_62_MDI_TN_P2__FUNC_CTS2_N (MTK_PIN_NO(62) | 4)
#define MT7622_PIN_62_MDI_TN_P2__FUNC_RXD4 (MTK_PIN_NO(62) | 5)

#define MT7622_PIN_63_MDI_TP_P3__FUNC_ESW_TXEN (MTK_PIN_NO(63) | 0)
#define MT7622_PIN_63_MDI_TP_P3__FUNC_GPIO63 (MTK_PIN_NO(63) | 1)
#define MT7622_PIN_63_MDI_TP_P3__FUNC_G1_TXEN (MTK_PIN_NO(63) | 2)
#define MT7622_PIN_63_MDI_TP_P3__FUNC_SPIC0_CLK (MTK_PIN_NO(63) | 4)

#define MT7622_PIN_64_MDI_TN_P3__FUNC_ESW_TXC (MTK_PIN_NO(64) | 0)
#define MT7622_PIN_64_MDI_TN_P3__FUNC_GPIO64 (MTK_PIN_NO(64) | 1)
#define MT7622_PIN_64_MDI_TN_P3__FUNC_G1_TXC (MTK_PIN_NO(64) | 2)
#define MT7622_PIN_64_MDI_TN_P3__FUNC_SPIC0_MOSI (MTK_PIN_NO(64) | 4)

#define MT7622_PIN_65_MDI_RP_P3__FUNC_ESW_RXD0 (MTK_PIN_NO(65) | 0)
#define MT7622_PIN_65_MDI_RP_P3__FUNC_GPIO65 (MTK_PIN_NO(65) | 1)
#define MT7622_PIN_65_MDI_RP_P3__FUNC_G1_RXD0 (MTK_PIN_NO(65) | 2)
#define MT7622_PIN_65_MDI_RP_P3__FUNC_SPIC0_MISO (MTK_PIN_NO(65) | 4)

#define MT7622_PIN_66_MDI_RN_P3__FUNC_ESW_RXD1 (MTK_PIN_NO(66) | 0)
#define MT7622_PIN_66_MDI_RN_P3__FUNC_GPIO66 (MTK_PIN_NO(66) | 1)
#define MT7622_PIN_66_MDI_RN_P3__FUNC_G1_RXD1 (MTK_PIN_NO(66) | 2)
#define MT7622_PIN_66_MDI_RN_P3__FUNC_SPIC0_CS (MTK_PIN_NO(66) | 4)

#define MT7622_PIN_67_MDI_RP_P4__FUNC_ESW_RXD2 (MTK_PIN_NO(67) | 0)
#define MT7622_PIN_67_MDI_RP_P4__FUNC_GPIO67 (MTK_PIN_NO(67) | 1)
#define MT7622_PIN_67_MDI_RP_P4__FUNC_G1_RXD2 (MTK_PIN_NO(67) | 2)
#define MT7622_PIN_67_MDI_RP_P4__FUNC_PWM_CH4 (MTK_PIN_NO(67) | 3)
#define MT7622_PIN_67_MDI_RP_P4__FUNC_SPIC1_CLK (MTK_PIN_NO(67) | 4)

#define MT7622_PIN_68_MDI_RN_P4__FUNC_ESW_RXD3 (MTK_PIN_NO(68) | 0)
#define MT7622_PIN_68_MDI_RN_P4__FUNC_GPIO68 (MTK_PIN_NO(68) | 1)
#define MT7622_PIN_68_MDI_RN_P4__FUNC_G1_RXD3 (MTK_PIN_NO(68) | 2)
#define MT7622_PIN_68_MDI_RN_P4__FUNC_PWM_CH5 (MTK_PIN_NO(68) | 3)
#define MT7622_PIN_68_MDI_RN_P4__FUNC_SPIC1_MOSI (MTK_PIN_NO(68) | 4)

#define MT7622_PIN_69_MDI_TP_P4__FUNC_ESW_RXDV (MTK_PIN_NO(69) | 0)
#define MT7622_PIN_69_MDI_TP_P4__FUNC_GPIO69 (MTK_PIN_NO(69) | 1)
#define MT7622_PIN_69_MDI_TP_P4__FUNC_G1_RXDV (MTK_PIN_NO(69) | 2)
#define MT7622_PIN_69_MDI_TP_P4__FUNC_PWM_CH6 (MTK_PIN_NO(69) | 3)
#define MT7622_PIN_69_MDI_TP_P4__FUNC_SPIC1_MISO (MTK_PIN_NO(69) | 4)

#define MT7622_PIN_70_MDI_TN_P4__FUNC_ESW_RXC (MTK_PIN_NO(70) | 0)
#define MT7622_PIN_70_MDI_TN_P4__FUNC_GPIO70 (MTK_PIN_NO(70) | 1)
#define MT7622_PIN_70_MDI_TN_P4__FUNC_G1_RXC (MTK_PIN_NO(70) | 2)
#define MT7622_PIN_70_MDI_TN_P4__FUNC_PWM_CH7 (MTK_PIN_NO(70) | 3)
#define MT7622_PIN_70_MDI_TN_P4__FUNC_SPIC1_CS (MTK_PIN_NO(70) | 4)

#define MT7622_PIN_71_SPI2_CK__FUNC_SPI2_CK (MTK_PIN_NO(71) | 0)
#define MT7622_PIN_71_SPI2_CK__FUNC_GPIO71 (MTK_PIN_NO(71) | 1)

#define MT7622_PIN_72_SPI2_DATA__FUNC_SPI2_DATA (MTK_PIN_NO(72) | 0)
#define MT7622_PIN_72_SPI2_DATA__FUNC_GPIO72 (MTK_PIN_NO(72) | 1)

#define MT7622_PIN_73_SPIC1_CLK__FUNC_SPIC1_CLK (MTK_PIN_NO(73) | 0)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_GPIO73 (MTK_PIN_NO(73) | 1)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_TXD1 (MTK_PIN_NO(73) | 2)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_I2C1_SCL (MTK_PIN_NO(73) | 3)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_PWM_CH1 (MTK_PIN_NO(73) | 4)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_ANTSEL12 (MTK_PIN_NO(73) | 5)
#define MT7622_PIN_73_SPIC1_CLK__FUNC_DBG_UTIF0 (MTK_PIN_NO(73) | 7)

#define MT7622_PIN_74_SPIC1_MOSI__FUNC_SPIC1_MOSI (MTK_PIN_NO(74) | 0)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_GPIO74 (MTK_PIN_NO(74) | 1)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_RXD1 (MTK_PIN_NO(74) | 2)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_I2C1_SDA (MTK_PIN_NO(74) | 3)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_PWM_CH2 (MTK_PIN_NO(74) | 4)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_ANTSEL13 (MTK_PIN_NO(74) | 5)
#define MT7622_PIN_74_SPIC1_MOSI__FUNC_DBG_UTIF1 (MTK_PIN_NO(74) | 7)

#define MT7622_PIN_75_SPIC1_MISO__FUNC_SPIC1_MISO (MTK_PIN_NO(75) | 0)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_GPIO75 (MTK_PIN_NO(75) | 1)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_RTS1_N (MTK_PIN_NO(75) | 2)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_I2C2_SCL (MTK_PIN_NO(75) | 3)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_PWM_CH3 (MTK_PIN_NO(75) | 4)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_ANTSEL14 (MTK_PIN_NO(75) | 5)
#define MT7622_PIN_75_SPIC1_MISO__FUNC_DBG_UTIF2 (MTK_PIN_NO(75) | 7)

#define MT7622_PIN_76_SPIC1_CS__FUNC_SPIC1_CS (MTK_PIN_NO(76) | 0)
#define MT7622_PIN_76_SPIC1_CS__FUNC_GPIO76 (MTK_PIN_NO(76) | 1)
#define MT7622_PIN_76_SPIC1_CS__FUNC_CTS1_N (MTK_PIN_NO(76) | 2)
#define MT7622_PIN_76_SPIC1_CS__FUNC_I2C2_SDA (MTK_PIN_NO(76) | 3)
#define MT7622_PIN_76_SPIC1_CS__FUNC_PWM_CH4 (MTK_PIN_NO(76) | 4)
#define MT7622_PIN_76_SPIC1_CS__FUNC_ANTSEL15 (MTK_PIN_NO(76) | 5)
#define MT7622_PIN_76_SPIC1_CS__FUNC_DBG_UTIF3 (MTK_PIN_NO(76) | 7)

#define MT7622_PIN_77_GPIO_D__FUNC_GPIO77 (MTK_PIN_NO(77) | 1)
#define MT7622_PIN_77_GPIO_D__FUNC_PWM_CH5 (MTK_PIN_NO(77) | 4)
#define MT7622_PIN_77_GPIO_D__FUNC_ANTSEL16 (MTK_PIN_NO(77) | 5)
#define MT7622_PIN_77_GPIO_D__FUNC_DBG_UTIF4 (MTK_PIN_NO(77) | 7)

#define MT7622_PIN_78_WATCHDOG__FUNC_WATCHDOG (MTK_PIN_NO(78) | 0)
#define MT7622_PIN_78_WATCHDOG__FUNC_GPIO78 (MTK_PIN_NO(78) | 1)
#define MT7622_PIN_78_WATCHDOG__FUNC_PWM_CH6 (MTK_PIN_NO(78) | 4)
#define MT7622_PIN_78_WATCHDOG__FUNC_ANTSEL17 (MTK_PIN_NO(78) | 5)
#define MT7622_PIN_78_WATCHDOG__FUNC_DBG_UTIF5 (MTK_PIN_NO(78) | 7)

#define MT7622_PIN_79_RTS3_N__FUNC_RTS3_N (MTK_PIN_NO(79) | 0)
#define MT7622_PIN_79_RTS3_N__FUNC_GPIO79 (MTK_PIN_NO(79) | 1)
#define MT7622_PIN_79_RTS3_N__FUNC_SPIC0_MISO (MTK_PIN_NO(79) | 3)
#define MT7622_PIN_79_RTS3_N__FUNC_PCIE0_PAD_WAKE_N (MTK_PIN_NO(79) | 4)
#define MT7622_PIN_79_RTS3_N__FUNC_ANTSEL18 (MTK_PIN_NO(79) | 5)
#define MT7622_PIN_79_RTS3_N__FUNC_DBG_UTIF6 (MTK_PIN_NO(79) | 7)

#define MT7622_PIN_80_CTS3_N__FUNC_CTS3_N (MTK_PIN_NO(80) | 0)
#define MT7622_PIN_80_CTS3_N__FUNC_GPIO80 (MTK_PIN_NO(80) | 1)
#define MT7622_PIN_80_CTS3_N__FUNC_SPIC0_CS (MTK_PIN_NO(80) | 3)
#define MT7622_PIN_80_CTS3_N__FUNC_PCIE0_PAD_CLKREQ_N (MTK_PIN_NO(80) | 4)
#define MT7622_PIN_80_CTS3_N__FUNC_ANTSEL19 (MTK_PIN_NO(80) | 5)
#define MT7622_PIN_80_CTS3_N__FUNC_DBG_UTIF7 (MTK_PIN_NO(80) | 7)

#define MT7622_PIN_81_TXD3__FUNC_TXD3 (MTK_PIN_NO(81) | 0)
#define MT7622_PIN_81_TXD3__FUNC_GPIO81 (MTK_PIN_NO(81) | 1)
#define MT7622_PIN_81_TXD3__FUNC_SPDIF_T (MTK_PIN_NO(81) | 2)
#define MT7622_PIN_81_TXD3__FUNC_SPIC0_CLK (MTK_PIN_NO(81) | 3)
#define MT7622_PIN_81_TXD3__FUNC_PWM_CH6 (MTK_PIN_NO(81) | 4)
#define MT7622_PIN_81_TXD3__FUNC_ANTSEL20 (MTK_PIN_NO(81) | 5)
#define MT7622_PIN_81_TXD3__FUNC_DBG_UTIF8 (MTK_PIN_NO(81) | 7)

#define MT7622_PIN_82_RXD3__FUNC_RXD3 (MTK_PIN_NO(82) | 0)
#define MT7622_PIN_82_RXD3__FUNC_GPIO82 (MTK_PIN_NO(82) | 1)
#define MT7622_PIN_82_RXD3__FUNC_SPDIF_R (MTK_PIN_NO(82) | 2)
#define MT7622_PIN_82_RXD3__FUNC_SPIC0_MOSI (MTK_PIN_NO(82) | 3)
#define MT7622_PIN_82_RXD3__FUNC_PWM_CH7 (MTK_PIN_NO(82) | 4)
#define MT7622_PIN_82_RXD3__FUNC_ANTSEL21 (MTK_PIN_NO(82) | 5)
#define MT7622_PIN_82_RXD3__FUNC_DBG_UTIF9 (MTK_PIN_NO(82) | 7)

#define MT7622_PIN_83_PERST0_N__FUNC_PCIE0_PAD_PERST_N (MTK_PIN_NO(83) | 0)
#define MT7622_PIN_83_PERST0_N__FUNC_GPIO83 (MTK_PIN_NO(83) | 1)

#define MT7622_PIN_84_PERST1_N__FUNC_PCIE1_PAD_PERST_N (MTK_PIN_NO(84) | 0)
#define MT7622_PIN_84_PERST1_N__FUNC_GPIO84 (MTK_PIN_NO(84) | 1)

#define MT7622_PIN_85_WLED_N__FUNC_WLED_N (MTK_PIN_NO(85) | 0)
#define MT7622_PIN_85_WLED_N__FUNC_GPIO85 (MTK_PIN_NO(85) | 1)

#define MT7622_PIN_86_EPHY_LED0_N__FUNC_EPHY_LED0_N (MTK_PIN_NO(86) | 0)
#define MT7622_PIN_86_EPHY_LED0_N__FUNC_GPIO86 (MTK_PIN_NO(86) | 1)
#define MT7622_PIN_86_EPHY_LED0_N__FUNC_CPUM_HW_SEL (MTK_PIN_NO(86) | 4)
#define MT7622_PIN_86_EPHY_LED0_N__FUNC_FPC_CTL0 (MTK_PIN_NO(86) | 6)
#define MT7622_PIN_86_EPHY_LED0_N__FUNC_JTRST_N (MTK_PIN_NO(86) | 7)

#define MT7622_PIN_87_AUXIN0__FUNC_I2C1_SCL (MTK_PIN_NO(87) | 0)
#define MT7622_PIN_87_AUXIN0__FUNC_GPIO87 (MTK_PIN_NO(87) | 1)

#define MT7622_PIN_88_AUXIN1__FUNC_I2C1_SDA (MTK_PIN_NO(88) | 0)
#define MT7622_PIN_88_AUXIN1__FUNC_GPIO88 (MTK_PIN_NO(88) | 1)

#define MT7622_PIN_89_AUXIN2__FUNC_I2C2_SCL (MTK_PIN_NO(89) | 0)
#define MT7622_PIN_89_AUXIN2__FUNC_GPIO89 (MTK_PIN_NO(89) | 1)

#define MT7622_PIN_90_AUXIN3__FUNC_I2C2_SDA (MTK_PIN_NO(90) | 0)
#define MT7622_PIN_90_AUXIN3__FUNC_GPIO90 (MTK_PIN_NO(90) | 1)

#define MT7622_PIN_91_TXD4__FUNC_TXD4 (MTK_PIN_NO(91) | 0)
#define MT7622_PIN_91_TXD4__FUNC_GPIO91 (MTK_PIN_NO(91) | 1)
#define MT7622_PIN_91_TXD4__FUNC_EPHY_LED1_N (MTK_PIN_NO(91) | 2)
#define MT7622_PIN_91_TXD4__FUNC_DFD_TDI (MTK_PIN_NO(91) | 3)
#define MT7622_PIN_91_TXD4__FUNC_CPUM_2B_SEL (MTK_PIN_NO(91) | 4)
#define MT7622_PIN_91_TXD4__FUNC_ANTSEL0 (MTK_PIN_NO(91) | 5)
#define MT7622_PIN_91_TXD4__FUNC_FPC_CK_XI (MTK_PIN_NO(91) | 6)
#define MT7622_PIN_91_TXD4__FUNC_JTDI (MTK_PIN_NO(91) | 7)

#define MT7622_PIN_92_RXD4__FUNC_RXD4 (MTK_PIN_NO(92) | 0)
#define MT7622_PIN_92_RXD4__FUNC_GPIO92 (MTK_PIN_NO(92) | 1)
#define MT7622_PIN_92_RXD4__FUNC_EPHY_LED2_N (MTK_PIN_NO(92) | 2)
#define MT7622_PIN_92_RXD4__FUNC_DFD_TDO (MTK_PIN_NO(92) | 3)
#define MT7622_PIN_92_RXD4__FUNC_CPUM0 (MTK_PIN_NO(92) | 4)
#define MT7622_PIN_92_RXD4__FUNC_ANTSEL1 (MTK_PIN_NO(92) | 5)
#define MT7622_PIN_92_RXD4__FUNC_FPC_CTL1 (MTK_PIN_NO(92) | 6)
#define MT7622_PIN_92_RXD4__FUNC_JTDO (MTK_PIN_NO(92) | 7)

#define MT7622_PIN_93_RTS4_N__FUNC_RTS4_N (MTK_PIN_NO(93) | 0)
#define MT7622_PIN_93_RTS4_N__FUNC_GPIO93 (MTK_PIN_NO(93) | 1)
#define MT7622_PIN_93_RTS4_N__FUNC_EPHY_LED3_N (MTK_PIN_NO(93) | 2)
#define MT7622_PIN_93_RTS4_N__FUNC_DFD_TCK (MTK_PIN_NO(93) | 3)
#define MT7622_PIN_93_RTS4_N__FUNC_CPUM1 (MTK_PIN_NO(93) | 4)
#define MT7622_PIN_93_RTS4_N__FUNC_ANTSEL2 (MTK_PIN_NO(93) | 5)
#define MT7622_PIN_93_RTS4_N__FUNC_FPC_CTL2 (MTK_PIN_NO(93) | 6)
#define MT7622_PIN_93_RTS4_N__FUNC_JTCLK (MTK_PIN_NO(93) | 7)

#define MT7622_PIN_94_CTS4_N__FUNC_CTS4_N (MTK_PIN_NO(94) | 0)
#define MT7622_PIN_94_CTS4_N__FUNC_GPIO94 (MTK_PIN_NO(94) | 1)
#define MT7622_PIN_94_CTS4_N__FUNC_EPHY_LED4_N (MTK_PIN_NO(94) | 2)
#define MT7622_PIN_94_CTS4_N__FUNC_DFD_TMS (MTK_PIN_NO(94) | 3)
#define MT7622_PIN_94_CTS4_N__FUNC_CPUM2 (MTK_PIN_NO(94) | 4)
#define MT7622_PIN_94_CTS4_N__FUNC_ANTSEL3 (MTK_PIN_NO(94) | 5)
#define MT7622_PIN_94_CTS4_N__FUNC_FPC_CTL3 (MTK_PIN_NO(94) | 6)
#define MT7622_PIN_94_CTS4_N__FUNC_JTMS (MTK_PIN_NO(94) | 7)

#define MT7622_PIN_95_PWM1__FUNC_PWM_CH1 (MTK_PIN_NO(95) | 0)
#define MT7622_PIN_95_PWM1__FUNC_GPIO95 (MTK_PIN_NO(95) | 1)
#define MT7622_PIN_95_PWM1__FUNC_RTS4_N (MTK_PIN_NO(95) | 2)
#define MT7622_PIN_95_PWM1__FUNC_TXD2 (MTK_PIN_NO(95) | 3)
#define MT7622_PIN_95_PWM1__FUNC_CPUM3 (MTK_PIN_NO(95) | 4)
#define MT7622_PIN_95_PWM1__FUNC_ANTSEL4 (MTK_PIN_NO(95) | 5)
#define MT7622_PIN_95_PWM1__FUNC_FPC_DATA0 (MTK_PIN_NO(95) | 6)
#define MT7622_PIN_95_PWM1__FUNC_W_DBGIN (MTK_PIN_NO(95) | 7)

#define MT7622_PIN_96_PWM2__FUNC_PWM_CH2 (MTK_PIN_NO(96) | 0)
#define MT7622_PIN_96_PWM2__FUNC_GPIO96 (MTK_PIN_NO(96) | 1)
#define MT7622_PIN_96_PWM2__FUNC_CTS4_N (MTK_PIN_NO(96) | 2)
#define MT7622_PIN_96_PWM2__FUNC_RXD2 (MTK_PIN_NO(96) | 3)
#define MT7622_PIN_96_PWM2__FUNC_CPUM_CK_XI (MTK_PIN_NO(96) | 4)
#define MT7622_PIN_96_PWM2__FUNC_ANTSEL5 (MTK_PIN_NO(96) | 5)
#define MT7622_PIN_96_PWM2__FUNC_FPC_DATA1 (MTK_PIN_NO(96) | 6)
#define MT7622_PIN_96_PWM2__FUNC_W_DBGACK (MTK_PIN_NO(96) | 7)

#define MT7622_PIN_97_PWM3__FUNC_PWM_CH3 (MTK_PIN_NO(97) | 0)
#define MT7622_PIN_97_PWM3__FUNC_GPIO97 (MTK_PIN_NO(97) | 1)
#define MT7622_PIN_97_PWM3__FUNC_TXD4 (MTK_PIN_NO(97) | 2)
#define MT7622_PIN_97_PWM3__FUNC_AICE_TCKC (MTK_PIN_NO(97) | 4)
#define MT7622_PIN_97_PWM3__FUNC_ANTSEL6 (MTK_PIN_NO(97) | 5)
#define MT7622_PIN_97_PWM3__FUNC_FPC_DATA2 (MTK_PIN_NO(97) | 6)
#define MT7622_PIN_97_PWM3__FUNC_W_JTCLK (MTK_PIN_NO(97) | 7)

#define MT7622_PIN_98_PWM4__FUNC_PWM_CH4 (MTK_PIN_NO(98) | 0)
#define MT7622_PIN_98_PWM4__FUNC_GPIO98 (MTK_PIN_NO(98) | 1)
#define MT7622_PIN_98_PWM4__FUNC_RXD4 (MTK_PIN_NO(98) | 2)
#define MT7622_PIN_98_PWM4__FUNC_ANTSEL7 (MTK_PIN_NO(98) | 5)
#define MT7622_PIN_98_PWM4__FUNC_FPC_DATA3 (MTK_PIN_NO(98) | 6)
#define MT7622_PIN_98_PWM4__FUNC_W_JTDI (MTK_PIN_NO(98) | 7)

#define MT7622_PIN_99_PWM5__FUNC_PWM_CH5 (MTK_PIN_NO(99) | 0)
#define MT7622_PIN_99_PWM5__FUNC_GPIO99 (MTK_PIN_NO(99) | 1)
#define MT7622_PIN_99_PWM5__FUNC_IR_T (MTK_PIN_NO(99) | 3)
#define MT7622_PIN_99_PWM5__FUNC_AICE_TMSC (MTK_PIN_NO(99) | 4)
#define MT7622_PIN_99_PWM5__FUNC_ANTSEL8 (MTK_PIN_NO(99) | 5)
#define MT7622_PIN_99_PWM5__FUNC_FPC_DATA4 (MTK_PIN_NO(99) | 6)
#define MT7622_PIN_99_PWM5__FUNC_W_JTMS (MTK_PIN_NO(99) | 7)

#define MT7622_PIN_100_PWM6__FUNC_PWM_CH6 (MTK_PIN_NO(100) | 0)
#define MT7622_PIN_100_PWM6__FUNC_GPIO100 (MTK_PIN_NO(100) | 1)
#define MT7622_PIN_100_PWM6__FUNC_IR_R (MTK_PIN_NO(100) | 3)
#define MT7622_PIN_100_PWM6__FUNC_ANTSEL9 (MTK_PIN_NO(100) | 5)
#define MT7622_PIN_100_PWM6__FUNC_FPC_DATA5 (MTK_PIN_NO(100) | 6)
#define MT7622_PIN_100_PWM6__FUNC_W_JTRST_N (MTK_PIN_NO(100) | 7)

#define MT7622_PIN_101_PWM7__FUNC_PWM_CH7 (MTK_PIN_NO(101) | 0)
#define MT7622_PIN_101_PWM7__FUNC_GPIO101 (MTK_PIN_NO(101) | 1)
#define MT7622_PIN_101_PWM7__FUNC_ANTSEL10 (MTK_PIN_NO(101) | 5)
#define MT7622_PIN_101_PWM7__FUNC_FPC_DATA6 (MTK_PIN_NO(101) | 6)
#define MT7622_PIN_101_PWM7__FUNC_DBG_UART_TXD (MTK_PIN_NO(101) | 7)

#define MT7622_PIN_102_GPIO_E__FUNC_GPIO102 (MTK_PIN_NO(102) | 1)
#define MT7622_PIN_102_GPIO_E__FUNC_ANTSEL11 (MTK_PIN_NO(102) | 5)
#define MT7622_PIN_102_GPIO_E__FUNC_FPC_DATA7 (MTK_PIN_NO(102) | 6)
#define MT7622_PIN_102_GPIO_E__FUNC_W_JTDO (MTK_PIN_NO(102) | 7)

#endif				/* __DTS_MT7622_PINFUNC_H */
